<?php
namespace Epygi\Webrtc;
use Epygi\Shell\Command;
use Epygi\Enum\Role as ERole;

class WebRtcConfAuth
{
    const CONF_CLI = '/telephony/conferecne-cli';
    function __construct() {
    }

    private function getPasswordStatus($conference, $username, $password)
    {
        $cmd = new Command(self::CONF_CLI);
        $cmd->opt('auth');
        $cmd->opt("-c " . $conference);
        $cmd->opt("-p " . $password);
        $cmd->opt("-u " . $username);

        $cmd->execute();
        return array_shift($cmd->data);
    }
    public function authUser($conference, $username, $password)
    {
        $user = array('conf' => $conference, 'name' => $username, 'password' => $password, 'role' => -1, 'error' => '');
		$s = self::getPasswordStatus($conference, $username, $password);

		if($s == "participant"){
			$user['role'] = "participant";//ERole::PARTICIPANT;
		} elseif ($s == "moderator"){
			$user['role'] = "moderator";//ERole::CONFERENCE;
		}
		else{
			$user['error'] = $s;
			$user['role'] = -1;
		}
		return($user);
    }
}
