<?php
namespace Mvc;

class CustomLogo
{
    const LINK_CONFIG_FILE = '/tmp/companydetails/link.conf';

    private $key_tokens = array();

    protected function __construct()
    {
        if( file_exists( self::LINK_CONFIG_FILE ) )        
        {
            $lines = file(self::LINK_CONFIG_FILE);
            foreach ($lines as $line) {
                $parts = preg_split('/=/', trim($line), 2);
                if (count($parts) == 2) {
                    $this->key_tokens[$parts[0]] = $parts[1];
                }
            }
        }
    }
    
    protected static function getInstance()
    {
        static $obj = null;
        return $obj ? : $obj = new self();
    }

    protected function getValue( $pattern )
    {
        if( isset( $this->key_tokens[ $pattern ] ) )
        {
            $targetValue = substr( $this->key_tokens[ $pattern ], 1, -1 );
            return $targetValue;
        }
        else
        {
            return '';
        }		  
    }
    
    public static function isLoginLogoExist( )
    {
        return file_exists( '/tmp/companydetails/uploadedloginlogo.png' );
    }

    public static function isMainLogoExist( )
    {
        return file_exists( '/tmp/companydetails/uploadedlogo.png' );
    }

    public static function isSiteIconExist( )
    {
        return file_exists( '/tmp/companydetails/uploadedfavicon.ico' );
    }

    public static function getTitle( )
    {
        return self::getInstance()->getValue('companyShortName');
    }
		  
    public static function getCompanyURL( )
    {
        $httpService = "http://";
        $siteURL = self::getInstance()->getValue('companyUrl');
        if( $siteURL != '' )
        {
            return $httpService.$siteURL;
        }
        else
        {
            return $siteURL;
        }    
    }        
}