<?php
namespace Mvc;

class Session
{
    private $namespace = null;

    /**
     * Choose a namespace automatically if one is not already set.  The auto-selected namespace will be related to
     * the current page and if there is no current page, we'll use 'DEFAULT'.
     */
    public function __construct($namespace = null)
    {
        // no namespace passed in, auto-select based on page or use default
        if ($namespace === null) {
            $page = empty($_SERVER['PHP_SELF']) ? 'DEFAULT' : $_SERVER['PHP_SELF'];
            $namespace = md5($page);
        }

        // unique array key where we will store session data
        $this->namespace = $namespace;

        // make sure our session has been started.  For added security, generate a new session ID each page load.
        $sid = session_id( );
        if( empty( $sid ) ) {
                session_start();
            //session_regenerate_id(true);
        }
    }

    public function __get($key)
    {
        return isset($_SESSION[$this->namespace][$key]) ? $_SESSION[$this->namespace][$key] : null;
    }

    public function __set($key, $value)
    {
        // initialize our namespace if it doesn't yet exist
        if (!isset($_SESSION[$this->namespace])) {
            $_SESSION[$this->namespace] = array();
        }

        // set this key/value pair in our namespace
        $_SESSION[$this->namespace][$key] = $value;
    }

    /**
     * Clear all the data from this namespace.
     */
    public function clear()
    {
        unset($_SESSION[$this->namespace]);
    }

    /**
     * Destroys the entire session regardless of the namespace.  This may be useful for logging a user our entirely
     * and destroying all session data.
     */
    public function destroy()
    {
        // erase all data in the session and we'll start over again
        $_SESSION = array();
    }

    public function exchangeArray($data)
    {
        $_SESSION[$this->namespace] = $data;
    }

    /**
     * Normally you would just use the magic methods to set and get values, but in some cases you want to fetch a
     * default value if the key you request is not set.  Use 'get' to fetch with testing and defaults.
     */
    public function get($key, $default = null)
    {
        return isset($_SESSION[$this->namespace][$key]) ? $_SESSION[$this->namespace][$key] : $default;
    }

    public function getAll()
    {
        return isset($_SESSION[$this->namespace]) ? $_SESSION[$this->namespace] : array();
    }

    /**
     * Import values from an array into our namespace.
     */
    public function import($data)
    {
        foreach ($data as $key => $value) {
            $this->$key = $value;
        }
    }

    /**
     * A common practice is to read a parameter from the $_REQUEST array and set that value into the user's session.
     * This is handled seamlessly in one call below.  If the request value exists, it replaces the session data. If
     * the request value does not exist, the session value is returned.
     */
    public function requestFilter($key, $default = false)
    {
        // fetch the value from our request data superglobal
        $value = isset ($_REQUEST[$key]) ? $_REQUEST[$key] : null;

        // superglobal holds no value
        if (is_null($value)) {
            // read value from session
            $value = $this->get($key, null);

            // session value is defined ... use it!
            if (null !== $value) {
                return $value;
            }

            // no session value exists either, use the default value
            $value = $default;
        }

        // save our value into the session and return it
        $this->$key = $value;
        return $value;
    }

    /**
     * Wrapper function for magic method with same functionality.
     *
     * @param $key
     * @param $value
     *
     * @return mixed
     */
    public function set($key, $value)
    {
        return $this->$key = $value;
    }
}