<?php

class ApiMain {
  private $log;
  private $db;

  public function __construct () {
    // 3. LogMgmt and DB objects are created, both are single instance per HTTP request, passed down the flow
    //    Minimum non-fatal code- there is no try - catch here!
    $this->log = new LogMgmt();
    /*$this->db = new DB( $this->log );*/
  }

  public function process() {
    // 4. ApiRequest extends Request and handles HTTP request validation and controller/model creation
    $this->log->add(__FILE__ .":". __LINE__ ." creating new ApiRequest..");
    $requestObj = new ApiRequest( $this->log/*, $this->db */);
    // 5. Response handles output data formatting and delivery to caller
    $this->log->add(__FILE__ .":". __LINE__ ." creating new Response");
    $responseObj = new Response($this->log);

    $exceptionTxt = false;
    try {
      // 6. HTTP request validation - authorization, route, endpoint, access rights
      $this->log->setSection(LogMgmt::SECTION_REQUEST);
      $this->log->add(__FILE__ .":". __LINE__ ." HTTP request validation - authorization, route, endpoint",LogMgmt::LVL_DEBUG);
      $requestObj->validate();
      // 7. Controller object creation, registration of endpoints
      $this->log->add(__FILE__ .":". __LINE__ ." Controller object creation, registration of endpoints",LogMgmt::LVL_DEBUG);
      $controllerObj = $requestObj->createController();
      // 8. Argument validation and passing control to model
      $this->log->add(__FILE__ .":". __LINE__ .": Argument validation and passing control to model"
		   . "; key:" . $requestObj->getRoute() . "Model_" . $requestObj->getVersion() . ":" . $requestObj->getEndpoint()
		   ,LogMgmt::LVL_DEBUG
		   );
      $this->log->setSection(LogMgmt::SECTION_RESPONSE);
      $responseArray = $controllerObj->execute();
      $responseObj->setHttpResponseCode( $responseArray[ApiConstants::STATUS_CODE] );
      $responseObj->setHttpResponseData( $responseArray[ApiConstants::MESSAGE]);
    }
    catch(ApiException $e) {
      // Framework level exceptions, corresponding code and message are set in response, more detailed info is being logged
      $exceptionTxt = true;
      $responseObj->setHttpResponseCode( $e->getCode() );
      $rawResponse = array(
        ApiConstants::KEY_SUCCESS => false,
        ApiConstants::KEY_ERROR => array(
          ApiConstants::KEY_CODE => $e->getCode(),
          ApiConstants::KEY_MESSAGE => $e->getMessage()
        )
      );
      $responseObj->setHttpResponseData(array(ApiConstants::MESSAGE => $e->getMessage(), ApiConstants::KEY_RAW_RESPONSE => $rawResponse));
      $this->log->add(__FILE__ . ":" . __LINE__  . " : ". $e->getCode() . " : " . $e->getMessage() . print_r($e->getLogData(), true),
           $e->getCode()==ApiConstants::http_Internal_Server_Error ? LogMgmt::LVL_FATAL : LogMgmt::LVL_ERROR, $e->getSection() );
    }
    catch(Exception $e) {
      // For safety only. Framework throws only ApiException and childs.
      $exceptionTxt = true;
      $responseObj->setHttpResponseCode(ApiConstants::http_Internal_Server_Error);
      $rawResponse = array(
        ApiConstants::KEY_SUCCESS => false,
          ApiConstants::KEY_ERROR => array(
            ApiConstants::KEY_CODE => $e->getCode(),
            ApiConstants::KEY_MESSAGE => $e->getMessage()
        )
      );
      $responseObj->setHttpResponseData(array(ApiConstants::MESSAGE => ApiConstants::INTERNAL_ERROR_MESSAGE, ApiConstants::KEY_RAW_RESPONSE => $rawResponse));
      $this->log->add(__FILE__ . ":" . __LINE__ . " " .$e->getCode() . " " . $e->getMessage(),  LogMgmt::LVL_FATAL);
    }
    // 9. Formatting and delivery of response data and code.
    $responseObj->deliver($requestObj->getFormat());
    // 10. Flush of log lines to file
    $this->log->flush($exceptionTxt);
  }

}
