<?php

class Request {
  protected $requestInfo;
  protected $log;
  protected  $db;

  public function __construct( $log/*,  $db*/) {
    $this->log = $log;
/*    $this->db = $db;*/
    $this->requestInfo = array(
      ApiConstants::API_VERSION => ApiConstants::UNDEFINED,
      ApiConstants::METHOD => ApiConstants::UNDEFINED,
      ApiConstants::ROUTE => ApiConstants::UNDEFINED,
      ApiConstants::ENDPOINT => ApiConstants::UNDEFINED,
      ApiConstants::FORMAT => ApiConstants::FORMAT_JSON
    );
  }

  public function validate() {
    //custom log level may be spcified for each requst
    if(!empty($_REQUEST[ApiConstants::LOG_LEVEL])) {
      $this->log->setCurrentLogLvl((int)$_REQUEST[ApiConstants::LOG_LEVEL]);
    }
    $this->log->add(__FILE__ . ":" . __LINE__ ." starting validateRoute",LogMgmt::LVL_DEBUG);
    $this->validateRoute();
    $this->log->add(__FILE__ . ":" . __LINE__ . print_r($this->requestInfo,true), LogMgmt::LVL_INFO, LogMgmt::SECTION_REQUEST);
  }

  public function createController()  {
    $this->log->add(__FILE__ . ":" . __LINE__ ." controller:;". print_r($this->requestInfo,true));
    $controller = $this->requestInfo[ApiConstants::ROUTE] . 'Controller';
    $model = $this->requestInfo[ApiConstants::ROUTE] . 'Model';
	  $version = $this->requestInfo[ApiConstants::API_VERSION];

    $fctl = dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'controllers' . DIRECTORY_SEPARATOR . $controller . '.php';
    $fmdl = dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . $model . '.php';
    $this->log->add(__FILE__ . ":" . __LINE__ ." Looking for fctl:$fctl, fmdl:$fmdl");
	  if (!file_exists($fctl) || !file_exists($fmdl)) {
        $this->log->add(__FILE__ . ":" . __LINE__ ." controller or model not found");
        throw new ApiException('Route ' . $this->requestInfo[ApiConstants::ROUTE] . ' not found',
                ApiConstants::http_Bad_Request, $this->requestInfo, LogMgmt::SECTION_REQUEST);
     }
     // $this->log->add(__FILE__ . ":" . __LINE__ ." fctl, fmdl found; classed loaded:" . print_r(get_declared_classes (),true));

    require_once($fctl);
    require_once($fmdl);
    $this->log->add(__FILE__ . ":" . __LINE__ . " require model & controller done; fctl:$fctl; fmdl:$fmdl; version:$version;");
		
	  $model      .= "_" . $version;
	  $controller .= "_" . $version;
    if (!method_exists($model, $this->getUnDashedMethod($this->requestInfo[ApiConstants::ENDPOINT]))) {
      throw new ApiException('Endpoint ' . $this->requestInfo[ApiConstants::ENDPOINT] . ' not found in route: ' . $this->requestInfo[ApiConstants::ROUTE],
         ApiConstants::http_Bad_Request, $this->requestInfo, LogMgmt::SECTION_REQUEST);
    }

    $modelObj = new $model( $this );
    $this->log->add(__FILE__ . ":" . __LINE__ . " new model & controller done");
    return new $controller( $this, $modelObj );
  }

  public function getEndpointTxt() {
	  return " Controller:" . $this->requestInfo[ApiConstants::ROUTE] .
             " Version:"  . $this->requestInfo[ApiConstants::API_VERSION] .
             " Endpoint:" . $this->requestInfo[ApiConstants::ENDPOINT];
  }

  public function getUnDashedMethod($endpoint){
      return str_replace('-','_',$endpoint);
  }

  public function getVersion() {
      return $this->requestInfo[ApiConstants::API_VERSION];
  }

  public function getFormat() {
      return $this->requestInfo[ApiConstants::FORMAT];
  }

  public function setFormat( $format) {
       $this->requestInfo[ApiConstants::FORMAT] = $format;
  }

  public function getRoute() {
      return $this->requestInfo[ApiConstants::ROUTE];
  }

  public function getEndpoint() {
      return $this->requestInfo[ApiConstants::ENDPOINT];
  }

  public function getMethod() {
      return $this->requestInfo[ApiConstants::METHOD];
  }

  public function getLogObj()  {
      return $this->log;
  }

  public function getDatabaseObj() {
      return $this->db;
  }

  private function validateRoute() {
    $this->requestInfo[ApiConstants::METHOD] = $this->parseRequestMethod();
    $this->requestInfo[ApiConstants::FORMAT] = (isset($_REQUEST["format"]) && !empty($_REQUEST["format"]) ? strtolower($_REQUEST["format"]) : ApiConstants::FORMAT_JSON);
    if(empty($_REQUEST["apiVersion"])) {
      throw new ApiException('API Version not specified', ApiConstants::http_Bad_Request, $this->requestInfo, LogMgmt::SECTION_REQUEST);
    }
	  $this->requestInfo[ApiConstants::API_VERSION] = $_REQUEST["apiVersion"];
    if(empty($_REQUEST["route"])) {
      throw new ApiException('Route not specified', ApiConstants::http_Bad_Request, $this->requestInfo, LogMgmt::SECTION_REQUEST);
    }
    $this->requestInfo[ApiConstants::ROUTE] = $_REQUEST["route"];
    $this->log->setRoute($this->requestInfo[ApiConstants::ROUTE]);

    if(empty($_REQUEST["endpoint"])) {
      throw new ApiException('Endpoint not specified', ApiConstants::http_Bad_Request, $this->requestInfo,  LogMgmt::SECTION_REQUEST);
    }
    else {
      $this->requestInfo[ApiConstants::ENDPOINT] = $_REQUEST["endpoint"];
    }

    $this->log->setEndpoint($this->requestInfo[ApiConstants::ENDPOINT]);

  	$logLvl = (isset($_REQUEST["logLevel"]) ? $_REQUEST["logLevel"] : "");
  	if(preg_match('/^(ALWAYS|FATAL|ERROR|INFO|DEBUG|TRACE)$/i', $logLvl)) {
  	   $this->log->setCurrentLogLvl(LogMgmt::$logArr[$logLvl]);
  	}
  }

  private function getValueForKey( $name)   {
    $name = strtoupper(preg_replace('/([A-Z])/', '_$1', $name));
    if (isset($_SERVER['HTTP_'.$name])) {
        return $_SERVER['HTTP_'.$name];
    } elseif (isset($_SERVER[$name])) {
        return $_SERVER[$name];
    } else {
        return null;
    }
  }

  private function parseRequestMethod()  {
    $method = strtoupper($this->getValueForKey('requestMethod'));
    if (!$method) {
        $method = 'GET';
    }
    $override = strtoupper($this->getValueForKey('xHttpMethodOverride'));
    if ($override && $method == 'POST') {
        $method = $override;
    }
    return $method;
  }

  public function addLog($logText, $logLevel = LogMgmt::LVL_DEBUG){
    $this->log->add($logText, $logLevel);
  }
}
