<?php

use Epygi\Enum\Role as ERole;

$_CONFIG = [
'root' => "/home/httpd/upload/"
]; 

openlog("upl.php", LOG_PID | LOG_PERROR, LOG_LOCAL0);

main();

function main() {
	date_default_timezone_set('UTC');

	$ip = isset($_SERVER['HTTP_CLIENT_IP']) 
    ? $_SERVER['HTTP_CLIENT_IP'] 
    : (isset($_SERVER['HTTP_X_FORWARDED_FOR']) 
      ? $_SERVER['HTTP_X_FORWARDED_FOR'] 
      : $_SERVER['REMOTE_ADDR']);
	  
	up_log($_SERVER['REQUEST_METHOD'] . " request from:" . $ip);
	authenticate_or_exit();
	call_if_exists('method_'.strtolower($_SERVER['REQUEST_METHOD']));
	exit_with_response_code(501);
}

function up_log($text) {
	syslog(LOG_INFO, $text);
}

function auth_basic() {

	if (!isset($_SERVER['PHP_AUTH_USER'])) {
		header('WWW-Authenticate: Basic realm="My Realm"');
		header('HTTP/1.0 401 Unauthorized');
		echo('Unauthorized');
		return false;
	}
	
	$username = $_SERVER['PHP_AUTH_USER'];
	$password = $_SERVER['PHP_AUTH_PW'];
	
	// look up password for this user
	$config = Epygi\Storage\ConfigFactory::acldb();
	$usercfg = $config[$username];
	$enabled = $usercfg->getBool('enabled', false);

	try {
			$pwd_check = Epygi\Shell\Command\CheckSAM::samCheck($username, $password);
		}
		catch(\Exception $e) {
		$pwd_check = array(0,0,0);
	}
	
	if ($username == 'admin') {
		if ($enabled && ( $pwd_check[0] == 1 ||
			($pwd_check[0] == -1 && $pwd_check[1] == 1))) {
			$role = ERole::ADMIN;
		}
	}
	// LOCALADMIN - this is the local admin user
	elseif ($this->username == 'localadmin') {
		if ($enabled && ( $pwd_check[0] == 1 ||
			($pwd_check[0] == -1 && $pwd_check[1] == 1))) {
			$role = ERole::LOCALADMIN;
		}
	}
	
	if($role != ERole::ADMIN && $reole != ERole::LOCALADMIN){
		echo('Wrong Credentials!');
		return false;
	}

	return true;
}

function authenticate_or_exit() {

  if (!authenticated()) {
	up_log('method: '.$_SERVER['REQUEST_METHOD'].' request: '.$_SERVER['REQUEST_URI']."");
    if (isset($_SERVER['PHP_AUTH_USER']))
      up_log('Failed login (user: '.$_SERVER['PHP_AUTH_USER'].')');
    else
      up_log('Not authenticated');
    
    header('WWW-Authenticate: Basic realm="DAV"');
    exit_with_response_code(401);
  }

  up_log('('.$_SERVER['PHP_AUTH_USER'].') ');
}

function authenticated() {
  return auth_basic();
}

function call_if_exists($function) {
  
  global $_CONFIG;
  up_log($_SERVER['REQUEST_METHOD'].' ');

  if (($target = preg_replace('!^'.$_SERVER['SCRIPT_NAME'].'!', '', $_SERVER['REQUEST_URI'])) == ''){
	$target = '/';
  } else {
	$path_parts = pathinfo(trim(($target)));
	$target = $path_parts['basename'];
  }

  if ($function == 'method_put')
    $content = '';
  else
    $content = file_get_contents('php://input');

  if (function_exists($function)) {
    up_log(quoted_printable_encode($target)."\n");
    $function($_CONFIG['root'], $target, $content);
    exit;
  }

  up_log('ERROR: Not Implemented ('.quoted_printable_encode($target).")\n");
  up_log('$content = '.var_export($content, true)."\n");
  up_log('$_SERVER = '.var_export($_SERVER, true)."\n");
}

function method_put($root, $target, $content) {
  if (!file_exists($root.$target))
    http_response_code(201);

  $input = fopen('php://input', 'r');
  
  up_log("destination file:" . $root.$target);
  
  $file = fopen($root.$target, 'w');
  while ($data = fread($input, 4096))
    fwrite($file, $data);
  fclose($file);
  fclose($input);
}

function method_delete($root, $target, $content) {

  if (!file_exists($root.$target))
    exit_with_response_code(404);

  rm($root.$target);
}

function exit_with_response_code($code) {
  http_response_code($code);
  exit;
}

function rm($target) {
  if (is_link($target) || !is_dir($target))
    return unlink($target);

  chmod($target, 0777);

  foreach (scandir($target) as $file) {
    if ($file == '.' || $file == '..')
      continue;
    if (!rm($target.DIRECTORY_SEPARATOR.$file))
      return false;
  }

  return rmdir($target);
}

closelog();
