<?php

class Response {
    // class members
    private $statusCode = ApiConstants::http_Not_Found;
    private $format = ApiConstants::FORMAT_JSON;
    private $responseData;
    private $log;

    public function __construct( $log, $format = ApiConstants::FORMAT_JSON, $code = ApiConstants::http_No_Content) {
        $this->log = $log;
        $this->format = $format;
        $this->statusCode = $code;
        $this->responseData = array();
    }

    public function getHttpResponseCode()  {
        return $this->statusCode;
    }

    public function setHttpResponseCode( $val) {
        $this->statusCode = $val;
    }

    protected function getHttpResponseJson() {
        return json_encode($this->responseData);
    }

    protected function getHttpResponseXml() {
        $xml = new SimpleXMLElement('<response></response>');
        $this->arrayToXml($this->responseData, $xml);
        return $xml->asXML();
    }

    protected function arrayToXml($data,  &$xml) {
        if ($data) {
            foreach ($data as $key => $value) {
                if (is_array($value)) {
                    if (is_numeric($key)) {
                        $key = 'item'.$key; //dealing with <0/>..<n/> issues
                    }
                    $subnode = $xml->addChild($key);
                    $this->arrayToXml($value, $subnode);
                } else {
                    $xml->addChild("$key",htmlspecialchars("$value"));
                }
           }
        }
    }

    public function setHttpResponseData( $val) {
        $this->responseData = $val;
    }

    public function addHttpResponseKeyVal( $key,  $val) {
        $this->responseData[$key] = $val;
    }

    public function getHttpResponseText() {
        return $this->responseData;
    }

    public function deliver( $format = ApiConstants::FORMAT_JSON) {
        $this->format = $format;
        header('HTTP/1.1 ' . $this->statusCode . ' ' . ApiConstants::getStatusCodeText($this->statusCode));
        header($this->getFormatLine());

        switch ($this->format) {
            case ApiConstants::FORMAT_BINARY:
                $invFile = null;
                if(array_key_exists(ApiConstants::KEY_FILE_NAME, $this->responseData)) {
                    $fileName = $this->responseData[ApiConstants::KEY_FILE_NAME];
                    if (file_exists($fileName)) {
                        header('Content-Description: File Transfer');
                        header('Content-Disposition: attachment; filename="'. basename($fileName) . '"');
                        header('Expires: 0');
                        header('Cache-Control: must-revalidate');
                        header('Pragma: public');
                        header('Content-Length: ' . filesize($fileName));
                        readfile($fileName);
                    }
                    else {
                        $invFile = "File does not exist:";
                    }
                } else {
                    $invFile = "File not specified for transfer";
                }
                if($invFile){
                    header('HTTP/1.1 500 Internal Server Error');
                    header('Content-Type: application/json; charset=utf-8');
                    $this->log->setCurrentLogLvl(LogMgmt::LVL_ALWAYS);
                    $this->log->add(__FILE__ . ":" . __LINE__ .$invFile);
                    $rawResponse = array (
                        ApiConstants::KEY_SUCCESS => false,
                        ApiConstants::KEY_ERROR => array(
                            ApiConstants::KEY_CODE => ApiConstants::GENERIC_ERROR_CODE,
                            ApiConstants::KEY_MESSAGE => ApiConstants::INTERNAL_ERROR_MESSAGE
                        )
                    );
                    echo json_encode(array(ApiConstants::MESSAGE => ApiConstants::INTERNAL_ERROR_MESSAGE, ApiConstants::KEY_RAW_RESPONSE => $rawResponse));
                }
                break;

            case ApiConstants::FORMAT_XML:
                echo $this->getHttpResponseXml();
                break;

            case ApiConstants::FORMAT_HTML:
                echo $this->getHttpResponseText();
                break;

            default: // Json response
                echo $this->getHttpResponseJson();
                break;
        }
        
        $this->log->add(__FILE__ . ":" . __LINE__ . " statusCode:" . $this->statusCode . "; responseData: \n" . print_r($this->responseData,true), LogMgmt::LVL_INFO, LogMgmt::SECTION_RESPONSE);
    }

    private function getFormatLine() {
        $txt = 'Content-Type: text/html; charset=utf-8';

        switch ($this->format) {
            case ApiConstants::FORMAT_JSON:
                $txt = 'Content-Type: application/json; charset=utf-8';
                break;

            case ApiConstants::FORMAT_XML:
                $txt = 'Content-Type: application/xml; charset=utf-8';
                break;

            case ApiConstants::FORMAT_BINARY:
                $txt = 'Content-Type: application/octet-stream;';
                break;

            default:
                $txt = 'Content-Type: text/html; charset=utf-8';
                break;
        }
        return $txt;
    }
}
