<?php
include_once (dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR .  "CtlValidations.php");

class VtigerController_v1 extends BaseController {

    public function __construct(ApiRequest $apiRequest, BaseModel $modelObj) {
        parent::__construct($apiRequest,$modelObj);

        $this->registerEndpoint("GetToken", "POST", array(
            array(ApiConstants::ARG_NAME=>"vTigerUrl", ApiConstants::ARG_ALIAS=>"vTigerUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"vTigerUserName", ApiConstants::ARG_ALIAS=>"vTigerUserName", ApiConstants::ARG_REGEX => '/^.*$/'),
        ));

        $this->registerEndpoint("GetSessionID", "POST", array(
            array(ApiConstants::ARG_NAME=>"vTigerUrl", ApiConstants::ARG_ALIAS=>"vTigerUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"vTigerUserName", ApiConstants::ARG_ALIAS=>"vTigerUserName", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"vTigerUserAccessKey", ApiConstants::ARG_ALIAS=>"vTigerUserAccessKey", ApiConstants::ARG_REGEX => '/^.*$/'),
        ));

        $this->registerEndpoint("ListTypes", "POST", array(
            array(ApiConstants::ARG_NAME=>"vTigerUrl", ApiConstants::ARG_ALIAS=>"vTigerUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
        ));

        $this->registerEndpoint("Describe", "POST", array(
            array(ApiConstants::ARG_NAME=>"vTigerUrl", ApiConstants::ARG_ALIAS=>"vTigerUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"elementType", ApiConstants::ARG_ALIAS=>"elementType", ApiConstants::ARG_REGEX => '/^(Calendar|Accounts|Contacts|Potentials|Documents|Emails|Campaigns|Events|Users|ModComments|EmailCampaigns|PrintTemplates|EventForms|Inbox|Forecast|Groups|Currency|DocumentFolders|CompanyDetails|LineItem|Tax|ProductTaxes|Roles)$/', ApiConstants::ARG_DEFAULT => 'Contacts'),
        ));

        $this->registerEndpoint("GetContactInfo", "POST", array(
            array(ApiConstants::ARG_NAME=>"vTigerUrl", ApiConstants::ARG_ALIAS=>"vTigerUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"phoneNumber", ApiConstants::ARG_ALIAS=>"phoneNumber", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"searchPhoneTypes", ApiConstants::ARG_ALIAS=>"searchPhoneTypes", ApiConstants::ARG_ISARRAY => CtlValidations_v1::PhoneTypes(), ApiConstants::ARG_DEFAULT => array()),
            array(ApiConstants::ARG_NAME=>"mandatoryFields", ApiConstants::ARG_ALIAS=>"mandatoryFields", ApiConstants::ARG_ISARRAY => CtlValidations_v1::MandatoryFields(), ApiConstants::ARG_DEFAULT => array()),
            array(ApiConstants::ARG_NAME=>"minNumOfMatchedDigits", ApiConstants::ARG_ALIAS=>"minNumOfMatchedDigits", ApiConstants::ARG_REGEX => '/^[0-9]*$/', ApiConstants::ARG_DEFAULT => 3),
            array(ApiConstants::ARG_NAME=>"exactMatch", ApiConstants::ARG_ALIAS=>"exactMatch", ApiConstants::ARG_DEFAULT => false),
        ));

        $this->registerEndpoint("GetMandatoryFields", "POST", array(
            array(ApiConstants::ARG_NAME=>"vTigerUrl", ApiConstants::ARG_ALIAS=>"vTigerUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"elementTypes", ApiConstants::ARG_ALIAS=>"elementTypes", ApiConstants::ARG_ISARRAY => CtlValidations_v1::elementTypes(), ApiConstants::ARG_DEFAULT => array()),
            array(ApiConstants::ARG_NAME=>"userDefinedMandatoryFields", ApiConstants::ARG_ALIAS=>"userDefinedMandatoryFields", ApiConstants::ARG_ISARRAY => CtlValidations_v1::MandatoryFields(), ApiConstants::ARG_DEFAULT => array())
        ));

        $this->registerEndpoint("GetPhonetypeFields", "POST", array(
            array(ApiConstants::ARG_NAME=>"vTigerUrl", ApiConstants::ARG_ALIAS=>"vTigerUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"elementTypes", ApiConstants::ARG_ALIAS=>"elementTypes", ApiConstants::ARG_ISARRAY => CtlValidations_v1::elementTypes(), ApiConstants::ARG_DEFAULT => array()),
        ));

        $this->registerEndpoint("GetListOfFields", "POST", array(
            array(ApiConstants::ARG_NAME=>"vTigerUrl", ApiConstants::ARG_ALIAS=>"vTigerUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"elementTypes", ApiConstants::ARG_ALIAS=>"elementTypes", ApiConstants::ARG_ISARRAY => CtlValidations_v1::elementTypes(), ApiConstants::ARG_DEFAULT => array()),
        ));
    
        $this->registerEndpoint("GetResourceInfo", "POST", array(
            array(ApiConstants::ARG_NAME=>"vTigerUrl", ApiConstants::ARG_ALIAS=>"vTigerUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"elementTypes", ApiConstants::ARG_ALIAS=>"elementTypes", ApiConstants::ARG_ISARRAY => CtlValidations_v1::elementTypes(), ApiConstants::ARG_DEFAULT => array('Contacts')),
        ));

        $this->registerEndpoint("CreateContact", "POST", array(
            array(ApiConstants::ARG_NAME=>"vTigerUrl", ApiConstants::ARG_ALIAS=>"vTigerUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"vTigerUserName", ApiConstants::ARG_ALIAS=>"vTigerUserName", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"firstname", ApiConstants::ARG_ALIAS=>"firstname", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"lastname", ApiConstants::ARG_ALIAS=>"lastname", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"mobile", ApiConstants::ARG_ALIAS=>"mobile", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"phone", ApiConstants::ARG_ALIAS=>"phone", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"homephone", ApiConstants::ARG_ALIAS=>"homephone", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"assistantphone", ApiConstants::ARG_ALIAS=>"assistantphone", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"otherhone", ApiConstants::ARG_ALIAS=>"otherhone", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"fax", ApiConstants::ARG_ALIAS=>"fax", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"email", ApiConstants::ARG_ALIAS=>"email", ApiConstants::ARG_REGEX => '/^[A-Za-z0-9-_.+%]+@[A-Za-z0-9-.]+.[A-Za-z]{2,4}$|^ $/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"description", ApiConstants::ARG_ALIAS=>"description", ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"assignedToOrigin", ApiConstants::ARG_ALIAS=>"assignedToOrigin", ApiConstants::ARG_REGEX => '/^(UserName|GroupName| )$/', ApiConstants::ARG_DEFAULT => 'UserName'),
            array(ApiConstants::ARG_NAME=>"assignedToName", ApiConstants::ARG_ALIAS=>"assignedToName", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"assigned_user_id", ApiConstants::ARG_ALIAS=>"assigned_user_id", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"customManadatoryFields", ApiConstants::ARG_ALIAS=>"customManadatoryFields", ApiConstants::ARG_ISARRAY => CtlValidations_v1::CustomManadatoryFields(), ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"id", ApiConstants::ARG_ALIAS=>"id", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
        ));
    }
}
?>
