<?php
namespace App\Maintenance;

use Epygi;
use Mvc;

class SecurityDiagnosticsForm extends Epygi\Form\AbstractForm
{
    const REPORT_FILE = '/tmp/securityreport.xml';

    public function execute()
    {
        $this->onFirstLoad();
        return true;
    }

    public function getLatestReportTitle()
    {
        // report file does not exist
        if (!file_exists(self::REPORT_FILE)) {
            return null;
        }

        // report file is empty
        if (filesize(self::REPORT_FILE) < 1) {
            return null;
        }

        // read file time in pretty format
        $timestamp = date('Y-m-d H:i', filemtime(self::REPORT_FILE));

        // return link title
        return _('Show Security Report') . ' (' . $timestamp . ')';
    }

    protected function onFirstLoad()
    {
        // reset
        $this->clear();
    }

    protected function prepare()
    {
        $this->hasAccessRights= Epygi\Storage\AclDb::hasAccessRights('security-diagnostics', Epygi\Auth::getRole());
        // audit button pressed
        $do_audit = Mvc\Param::request('securityauditbtn');
        $this->command_url = $do_audit ? '/maintenance/security-diagnostics-command' : false;
    }
}