<?php
namespace Epygi\Storage;

class PendingEvents
{
    public static $pendingEvents = '/mnt/bbram/state/pending_events.db';
    public static $eventsConf = '/etc/fiad-conf/mmevent.conf';
    public static function getEventsForLoginPage( )
    {
		try{
			$conf = MultisectionConfigFile::getInstance(static::$eventsConf);
			$temp_pendingEvents='';

			if(filetype(static::$pendingEvents) == "char"){
				$temp_pendingEvents = tempnam("/tmp","php_login_");
				$cmd = "nbcat " . static::$pendingEvents . " > " . $temp_pendingEvents; 
				system($cmd);
				$events = MultisectionConfigFile::getInstance($temp_pendingEvents);
			}
			else{
				$events = MultisectionConfigFile::getInstance(static::$pendingEvents);
			}
			
			$sections = $events->sections();
			$t = "";
			foreach ($sections as $section) {
				if($section->getBool("READ",true) == false) {
					$display = false;
					$conf_section = $conf->offsetGet($section->get("APP",'') . $section->get("NAME",''));
					if(intval($conf_section->get("ACTION",0)) & 256 ) {
						$display = true;
					}
					if( $display ) { 
						$t = $t . '<span style="font-weight:bold; padding-left: 60px; ';
						switch ($section->get("PRIO",0)) {
							case 1:
								$t = $t . "color:green;";
								break;
							case 2:
								$t = $t . "color:#9a9a39;";
								break;
							case 3:
								$t = $t . "color:red;";
								break;
							default:
							$t = $t . "color:black;";
							break;
						}
						$t = $t . '">';
						$timestamp = substr($section->getName(),0,strpos($section->getName(), '-'));
						$timestamp = intval($timestamp);
						$dt = new \DateTime("@$timestamp");
						$t = $t . $dt->format('Y-m-d H:i:s');
						$t = $t . " ";
						$t = $t . '<span style="padding-right: 10px">' . $section->get("APP",'') . '</span>';
						$t = $t . '<span style="padding-right: 10px">' . $section->get("NAME",'') . '</span>';
						$t = $t . '<span style="padding-right: 10px">' . $section->get("DESC",'') . '</span>';						
						$t = $t . "</span>";	
					}
				}
			}
			if(!empty($temp_pendingEvents)) {
			  if($temp_pendingEvents){
				  unlink($temp_pendingEvents);
			  }
			}
			return $t;
		}
		catch(\Exception $e)
		{
			return $e;
		}
    }  
}
