<?php
namespace Epygi\Webrtc;
use \DateTime;

class WebRtcConfToken
{
	const WEBRTC_AUTH_SECRET_FILE = '/var/janus/At';
	private static $secret = ''; 
	private static $timeout = 0;
    function __construct($t=5*60*60) {
		self::$timeout=$t;
		$file = fopen(self::WEBRTC_AUTH_SECRET_FILE,"r");
		self::$secret = rtrim(fgets($file));
		fclose($file);
    }
	private function base64UrlEncode($text)
	{
		return str_replace(
			['+', '/', '='],
			['-', '_', ''],
			base64_encode($text)
		);
	}

    private function makeToken($timeout, $data, $secret)
    {
		if (empty($secret))
		{
			return "";
		}

		$date = new DateTime;
		$timestamp = $date->getTimestamp();
		$expiry=$timestamp+$timeout;

		// Create the token header
		$header = json_encode([
			'typ' => 'JWT',
			'alg' => 'HS256'
		]);

		// Create the token payload
		$payload = json_encode([
			'confid' => isset($data["confid"])?$data["confid"]:"",
			'role' => isset($data["role"])?$data["role"]:"",
			'sipuser' => isset($data['sipuser'])?$data['sipuser']:"",
			'siphost' => isset($data['siphost'])?$data['siphost']:"",
			'exp' => $expiry
		]);

		// Encode Header
		$base64UrlHeader = self::base64UrlEncode($header);

		// Encode Payload
		$base64UrlPayload = self::base64UrlEncode($payload);

		// Create Signature Hash
		$signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $secret, true);

		// Encode Signature to Base64Url String
		$base64UrlSignature = self::base64UrlEncode($signature);

		// Create JWT
		$jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;

		return $jwt;
    }
	public function getToken($data)
    {
		return self::makeToken(self::$timeout, $data, self::$secret);
    }
}
