<?php
namespace Mvc;

use Epygi;

class Config
{
    const RUNTIME_INFO_FILE = '/tmp/runtimeinfo';

    private $configs = array(
        'extensiondb' => 'sqlite:/etc/fiad-conf/telephony/extensiondb.qdb',
        'webrtcclick2calldb' => 'sqlite:/etc/fiad-conf/telephony/webrtcclick2call.db'
    );

    protected function __construct()
    {
        // load entire config file
        $lines = file(self::RUNTIME_INFO_FILE);

        // process each config file line
        foreach ($lines as $line) {
            // split on the "=" character
            $parts = preg_split('/=/', trim($line), 2);

            // if we have 2 parts, the first part is the key and the second is the value
            if (count($parts) == 2) {
                $this->configs[$parts[0]] = $parts[1];
            }
        }
    }

    /**
     * @param $key - config key (ex: FEATURE_CLI, HW_TYPE, PRODUCT_CLASS, etc)
     *
     * @return string|null - value set in config file, null if not set
     */
    public function get($key)
    {
        return isset($this->configs[$key]) ? $this->configs[$key] : null;
    }

    public static function getHostname()
    {
        $conf = Epygi\Storage\ConfigFactory::rc();
        return $conf->get('HOSTNAME');
    }

    public static function getDomainname()
    {
        $conf = Epygi\Storage\ConfigFactory::rc();
        return $conf->get('DOMAINNAME');
    }

    /**
     * Treat the config class as a singleton.  We create just 1 instance and reuse references to that instance.
     * @return Config - instance of the config class
     */
    protected static function getInstance()
    {
        static $instance = null;
        return $instance ? : $instance = new self();
    }

    public static function getProductName()
    {
        return self::getInstance()->get('SHORT_PRODUCT_NAME');
    }

    public static function getProductNameFull()
    {
        return self::getInstance()->get('FULL_PRODUCT_NAME');
    }

    public static function getUniqueId()
    {
        return self::getInstance()->get('UNIT_UNIQUE_ID');
    }

    public static function getDb($db_dsn)
    {
        return self::getInstance()->get($db_dsn);
    }

    /**
     * Checking to see if we are on the dev environment is so common.
     */
    public static function isDev()
    {
        return !Feature::hasRelease();
    }

    public static function getEventsForLoginPage()
    {
        $conf = new Epygi\Storage\PendingEvents();
        return $conf->getEventsForLoginPage();
    }
    
    public static function getVersion()
    {
	$abs_file_path = '/etc/version.txt';
        // make sure file exists
        if (!file_exists($abs_file_path)) {
	    return "";
        }

        // open file for reading
        $fh = fopen($abs_file_path, 'r');
        if (!$fh) {
            return "";
        }
        // read one line at a time into buffer
        while (!feof($fh)) {

            // read line from file
            $line = trim(fgets($fh));

            // blank line
            if (!$line) {
                continue;
            }

            // comment
            elseif (preg_match('/^\s*#|^\s*\/\//', $line)) {
                continue;
            }
            elseif (preg_match('/^\s*(.+?)\s*:(.*)$/', $line, $regs)) {
                $key = trim($regs[1]);
                $value = trim($regs[2]);
		
		if ( $key == "Version" ){
    		    $version = $value;
		}

		if ( $key == "Flavour" ){
    		    $version = $version . $value;
		}
                continue;
            }
            else {
                continue;
            }
        }

        fclose($fh);

        return $version;
    }

}