<?php
class ApiConstants {
  const  API_VERSION = "apiVersion";
  const  METHOD = "method";
  const  ROUTE = "route";
  const  ENDPOINT = "endpoint";
  const  ARGUMENTS = "args";
  const  FORMAT = "format";
  const  LOG_LEVEL = "logLevel";
  const  STATUS_CODE = "code";
  const  MESSAGE = "msg";
  const  UNDEFINED = "undefined";
  const  INTERNAL_ERROR_MESSAGE = "Fatal error occured"; //needs to be clarified
  const  GENERIC_ERROR_CODE = "GENERIC_ERROR";

  const  ARG_NAME = 'argName';
  const  ARG_ALIAS = 'argAlias';
  const  ARG_REGEX = 'argRegex';
  const  ARG_DEFAULT = 'argDefault';
  const  ARG_COMPLEX = 'argComplex';
  const  ARG_ENUM = 'argEnum';
  const  ARG_ISARRAY = 'argIsArray';
  const  ARG_TYPE = 'argType';
  const  BODY_KEY_NEEDS_TO_BE_ADDED = 'missingBodyKeyNeedsToBeAdded';

  const  KEY_STATUS = 'status';
  const  KEY_ERROR = 'error';
  const  KEY_ERROR_CODE = 'errorCode';
  const  KEY_ERROR_MESSAGE = 'errorMessage';
  const  KEY_RESPONSE = 'response';
  const  KEY_RAW_RESPONSE = 'rawResponse';
  const  KEY_RESULT = 'result';
  const  KEY_DETAILED_RESPONSE = 'detailedResponse';
  const  KEY_FILE_NAME = 'fileName';
  const  KEY_SUCCESS = 'success';
  const  KEY_CODE = 'code';
  const  KEY_MESSAGE = 'message';

  // http formats
  const  FORMAT_X_WWW_FORM = 'wwwForm';
  const  FORMAT_JSON = 'json';
  const  FORMAT_XML = 'xml';
  const  FORMAT_BINARY = 'binary';
  const  FORMAT_HTML = 'html';

  // http response codes
  const http_Continue = 100;
  const http_Switching_Protocols = 101;
  const http_OK = 200;
  const http_Created = 201;
  const http_Accepted = 202;
  const http_Non_Authoritative_Information = 203;
  const http_No_Content = 204;
  const http_Reset_Content = 205;
  const http_Partial_Content = 206;
  const http_Multiple_Choices = 300;
  const http_Moved_Permanently = 301;
  const http_Found = 302;
  const http_See_Other = 303;
  const http_Not_Modified = 304;
  const http_Use_Proxy = 305;
  const http_Temporary_Redirect = 307;
  const http_Bad_Request = 400;
  const http_Unauthorized = 401;
  const http_Payment_Required = 402;
  const http_Forbidden = 403;
  const http_Not_Found = 404;
  const http_Method_Not_Allowed = 405;
  const http_Not_Acceptable = 406;
  const http_Proxy_Authentication_Required = 407;
  const http_Request_Time_Out = 408;
  const http_Conflict = 409;
  const http_Gone = 410;
  const http_Length_Required = 411;
  const http_Precondition_Failed = 412;
  const http_Request_Entity_Too_Large = 413;
  const http_Request_URI_Too_Long = 414;
  const http_Unsupported_Media_Type = 415;
  const http_Requested_Range_Not_Satisfiable = 416;
  const http_Expectation_Failed = 417;
  const http_Internal_Server_Error = 500;
  const http_Not_Implemented = 501;
  const http_Bad_Gateway = 502;
  const http_Service_Unavailable = 503;
  const http_Gateway_Time_Out = 504;
  const http_HTTP_Version_Not_Supported = 505;

  private static $http_response_code = array (
       self::http_Continue => "Continue"
     , self::http_Switching_Protocols => "Switching Protocols"
     , self::http_OK => "OK"
     , self::http_Created => "Created"
     , self::http_Accepted => "Accepted"
     , self::http_Non_Authoritative_Information => "Non-Authoritative Information"
     , self::http_No_Content => "No Content"
     , self::http_Reset_Content => "Reset Content"
     , self::http_Partial_Content => "Partial Content"
     , self::http_Multiple_Choices => "Multiple Choices"
     , self::http_Moved_Permanently => "Moved Permanently"
     , self::http_Found => "Found"
     , self::http_See_Other => "See Other"
     , self::http_Not_Modified => "Not Modified"
     , self::http_Use_Proxy => "Use Proxy"
     , self::http_Temporary_Redirect => "Temporary Redirect"
     , self::http_Bad_Request => "Bad Request"
     , self::http_Unauthorized => "Unauthorized"
     , self::http_Payment_Required => "Payment Required"
     , self::http_Forbidden => "Forbidden"
     , self::http_Not_Found => "Not Found"
     , self::http_Method_Not_Allowed => "Method Not Allowed"
     , self::http_Not_Acceptable => "Not Acceptable"
     , self::http_Proxy_Authentication_Required => "Proxy Authentication Required"
     , self::http_Request_Time_Out => "Request Time-out"
     , self::http_Conflict => "Conflict"
     , self::http_Gone => "Gone"
     , self::http_Length_Required => "Length Required"
     , self::http_Precondition_Failed => "Precondition Failed"
     , self::http_Request_Entity_Too_Large => "Request Entity Too Large"
     , self::http_Request_URI_Too_Long => "Request-URI Too Long"
     , self::http_Unsupported_Media_Type => "Unsupported Media Type"
     , self::http_Requested_Range_Not_Satisfiable => "Requested range not satisfiable"
     , self::http_Expectation_Failed => "Expectation Failed"
     , self::http_Internal_Server_Error => "Internal Server Error"
     , self::http_Not_Implemented => "Not Implemented"
     , self::http_Bad_Gateway => "Bad Gateway"
     , self::http_Service_Unavailable => "Service Unavailable"
     , self::http_Gateway_Time_Out => "Gateway Time-out"
     , self::http_HTTP_Version_Not_Supported => "HTTP Version not supported"
  );

  public static function getStatusCodeText($statusCode) {
    return (null === self::$http_response_code[$statusCode]) ? self::$http_response_code[http_Not_Found] : self::$http_response_code[$statusCode];
  }
};
