<?php

openlog("eqallprov", LOG_PID | LOG_PERROR, LOG_LOCAL0);

syslog(LOG_WARNING, "{$_SERVER['REQUEST_METHOD']} : {$_SERVER['REQUEST_URI']} : from: {$_SERVER['REMOTE_ADDR']} ({$_SERVER['HTTP_USER_AGENT']})");

function isSecure() {
  return
    (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');
}

// force to use https
if(!isSecure())
{
	syslog(LOG_WARNING, "Redirect to https");
    header("Location: https://" . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"]);
	die();
}

# prevent direct access
define("_SYS_EP_SECRETS_", true);

# include required defines
require_once(ROOT_DIR."/library/Epygi/Crypt/shared-secrets.def.php");
 
$auth = new Epygi\Crypt\HmacAuth(constant("EQALL_CFG_SHARED_SECRET"));

// get token parts
$token = $auth->gethmacauthToken();
$parts = explode(':', $token, 4);

syslog(LOG_WARNING, "Token: $token");

if (count($parts) != 4) {
	syslog(LOG_WARNING, "Invalid token");
	http_response_code(401);
	die("Unauthorized");
}

list($appid, $signature_to_verify, $nonce, $timestamp) = $parts;

// check for APP ID
if(!$appid == constant("EQALL_CFG_APP_ID")) {
	syslog(LOG_WARNING, "Invalid app id");
	http_response_code(401);
	die("Unauthorized");
}

// verifiy timestamp
if($auth->verifyTime($timestamp, 600 /*10 minutes*/)) {
	// get signature, request URI, request method
	$signature_to_verify = base64_decode($signature_to_verify);
	$signature_to_verify = bin2hex($signature_to_verify);
	$requestUri = strtolower($_SERVER['REQUEST_URI']);
	$string_to_verify = $_SERVER['REQUEST_METHOD'] . "." . constant("EQALL_CFG_APP_ID") . "." . $nonce . "." . $requestUri . "." . $timestamp;
	
	// verifiy signature
	if($auth->verify($string_to_verify,$signature_to_verify)) {
		// Get the file
		$fileToGet = "/home/httpd/".$_SERVER['REQUEST_URI'];
		if(file_exists($fileToGet))
		{
			// Open the file for reading
			$fp = fopen($fileToGet, 'r');
	 
			// Set mime type to header
			header('Content-type: '.mime_content_type($fileToGet));
	 
			// Send the contents of the file
			fpassthru($fp);
			fclose($fp);
			syslog(LOG_WARNING, "Success: $fileToGet");
		}
		else
		{
			// File not found
			syslog(LOG_WARNING, "File not found: $fileToGet");
			http_response_code(404);
			die('File not found');
		}
	}
	else {
		syslog(LOG_WARNING, "Signature verification failed.");
		http_response_code(401);
		die("Unauthorized");	
	}
}
else {
	syslog(LOG_WARNING, "Time verification is failed. Provided timestamp: $timestamp");
	http_response_code(401);
	die("Unauthorized");	
}
closelog();