<?php

namespace App\Controller;

use App;
use Epygi;
use Mvc;

class MaintenanceController extends Mvc\Controller
{
    public function _init()
    {
        Epygi\Auth::rejectUnlessAuth();
    }

    public function backupRestoreAction()
    {
    }

    public function burnAction()
    {
        $this->view->form = $form = new App\Maintenance\BurnForm();
        $form->process();
    }

    public function burncommandAction()
    {
        $cmd = new Epygi\Shell\Passthru('/etc/init.d/fw-update');
        $cmd->arg('update');
        $cmd->stderrToStdin();
        $cmd->executeMessageQueue(198);
        exit;
    }

    public function diagcommandAction()
    {
        // params
        $method = Mvc\Param::request('method');

        switch ($method) {
            case 'diagwan' :
                $cmd = new Epygi\Shell\Passthru('/bin/diag-daemon');
                $cmd->arg('-w');
                $cmd->stderrToStdin();
                $cmd->executeMessageQueue(199);
                exit;

            case 'diagnet' :
                $cmd = new Epygi\Shell\Passthru('/bin/diag-daemon');
                $cmd->arg('-d');
                $cmd->stderrToStdin();
                $cmd->executeMessageQueue(199);
                exit;

            case 'diage1t1' :
                $cmd = new Epygi\Shell\Passthru('/bin/diag-daemon');
                $cmd->arg('-e');
                $cmd->stderrToStdin();
                $cmd->executeMessageQueue(199);
                exit;

            case 'diagfan' :
                $cmd = new Epygi\Shell\Passthru('/bin/diag-daemon');
                $cmd->arg('-n');
                $cmd->stderrToStdin();
                $cmd->executeMessageQueue(199);
                exit;

            case 'diagisdn' :
                $cmd = new Epygi\Shell\Passthru('/bin/diag-daemon');
                $cmd->arg('-i');
                $cmd->stderrToStdin();
                $cmd->executeMessageQueue(199);
                exit;

            case 'diagfxo' :
                $cmd = new Epygi\Shell\Passthru('/bin/diag-daemon');
                $cmd->arg('-f');
                $cmd->stderrToStdin();
                $cmd->executeMessageQueue(199);
                exit;

            default :
                return;
                break;
        }
    }

    public function diagnosticsAction()
    {
        // form
        $this->view->form = $form = new App\Maintenance\DiagnosticsForm ();
        $form->process();
    }

    public function firmwareUpdateAction()
    {
        // form
        // $this->view->form = $form = new Form\System\Datetime();
        // $form->process();
    }

    public function languagePackAction()
    {
        // form
        // $this->view->form = $form = new Form\System\Email();
        // $form->process();
    }

    public function overviewAction()
    {
    }

    public function pingAction()
    {
        // form
        $this->view->form = $form = new App\Maintenance\PingForm ();
        $form->process();
    }

    public function pingcommandAction()
    {
        // params
        $target = Mvc\Param::request('target');

        if(filter_var($target, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
          $cmd = new Epygi\Shell\Passthru('/bin/ping6');
        }
        else
        {
      	  $cmd = new Epygi\Shell\Passthru('/bin/ping');
        }

        // ping command
        $cmd->opt('-c', '4');
        $cmd->arg($target);
        $cmd->stderrToStdin();
        $cmd->executePassthru(); // pass through to browser as we execute
        exit;
    }

    public function rebootAction()
    {
        // form
        $this->view->form = $form = new App\Maintenance\RebootForm();
        $form->process();
    }

    public function securityDiagnosticsAction()
    {
        $this->view->form = $form = new App\Maintenance\SecurityDiagnosticsForm ();
        $form->process();
    }

    public function securityDiagnosticsCommandAction()
    {
        /**
         * STEP 1: in step 1, we generate the /tmp/secdiagargs file by copying some values from the /tmp/acldb
         * file.  I have no idea, yet, why this is being done.
         */

        // prepare security diagnostics arguments file
        $file_name = '/tmp/secdiagargs';
        if (file_exists($file_name)) {
            unlink($file_name);
        }

        // generate new file
        $cfg = Epygi\Storage\ConfigFile::getInstance($file_name);

        // open acldb config file for reading
        $acldb = Epygi\Storage\ConfigFactory::acldb();

        // admin section
        $admin = $acldb['admin'];
        $cfg['admin'] = array(
            'name' => $admin->get('user_name'),
            'enabled' => $admin->getBool('enabled') ? 1 : 0,
            'pwd' => $admin->get('password'),
            'guipwd' => $admin->get('gui_pswd'),
            'role' => 2
        );

        // local admin section
        $ladmin = $acldb['localadmin'];
        $cfg['localadmin'] = array(
            'name' => $ladmin->get('user_name'),
            'enabled' => $ladmin->getBool('enabled') ? 1 : 0,
            'pwd' => $ladmin->get('password'),
            'guipwd' => $ladmin->get('gui_pswd'),
            'role' => 4
        );
	
	if( $cfg['localadmin']->guipwd == "" )
	{
	    $cfg['localadmin']->guipwd = $cfg['localadmin']->pwd;
	}
	if( $cfg['admin']->guipwd == "" )
	{
	    $cfg['admin']->guipwd = $cfg['admin']->pwd;
	}


        // save new file (ready to use!)
        $cfg->save();

        /**
         * STEP 2: run the /bin/diag-daemon command to generate the security diagnostic audit report.
         */
        // ADMIN security audit command
        if (Epygi\Auth::isAdmin()) {
            $cmd = new Epygi\Shell\Passthru('/bin/diag-daemon');
            $cmd->opt('-s'); // security audit
            $cmd->arg('a'); // admin
            $cmd->arg($file_name);
            $cmd->stderrToStdin();
            $cmd->executeMessageQueue(199);
            exit;
        }

        // LOCALADMIN security audit command
        else {
            $cmd = new Epygi\Shell\Passthru('/bin/diag-daemon');
            $cmd->opt('-s'); // security audit
            $cmd->arg('l'); // localadmin
            $cmd->arg($file_name);
            $cmd->stderrToStdin();
            $cmd->executeMessageQueue(199);
            exit;
        }
    }

    // TODO: test this
    public function testusbflashcommandAction()
    {
        // ping command
        $cmd = new Epygi\Shell\Passthru('/bin/usbtest');
        $cmd->stderrToStdin();
        $cmd->executePassthru(); // pass through to browser as we execute
        exit;
    }

    public function tracerouteAction()
    {
        // form
        $this->view->form = $form = new App\Maintenance\TracerouteForm ();
        $form->process();
    }

    public function tracerouteCommandAction()
    {
        // params
        $target = Mvc\Param::request('target');
		$useicmp = Mvc\Param::request('use_icmp');
		$cmdstr = '/bin/traceroute ';
		
		if(filter_var($target, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
			$cmdstr = $cmdstr . '-6 ';
			}

		if( $useicmp ) {
			$cmdstr = $cmdstr . '-I ';
		}
			
		$cmdstr = $cmdstr . '-w 3 -q 1';
		$cmd = new Epygi\Shell\Passthru($cmdstr);

        $cmd->arg($target);
        $cmd->stderrToStdin();
        $cmd->executePassthru(); // pass through to browser as we execute
        exit;
    }
}