<?php
define('ROOT_DIR', realpath(__DIR__ . '/..'));
define('VIEW_DIR', ROOT_DIR . '/assets/view');
define('DOCROOT', ROOT_DIR . '/public');

function dump()
{
    $args = func_get_args();
    foreach ($args as $arg) {
        print '<pre>' . htmlspecialchars(print_r($arg, true)) . '</pre>';
    }
}

function edump()
{
    static $index = 1;
    $args = func_get_args();
    foreach ($args as $arg) {
        error_log(sprintf('[%02d] %s', $index++, print_r($arg, true)));
    }
}

// class auto-loader
spl_autoload_register(
    function ($class_name) {
        // convert class name to file name
        $abs_file = ROOT_DIR . '/library/' . strtr(ltrim($class_name, '\\'), array('\\' => '/')) . '.php';

        // class file not found
        if (!file_exists($abs_file)) {
            return false;
        }

        // include class file
        include $abs_file;
        return true;
    }
);

// timezone
//date_default_timezone_set('US/Central'); // Asia/Yerevan');
date_default_timezone_set('Asia/Yerevan');

// select locale
Epygi\Locale::selectLocale();

/**
 * EVERYTHING BELOW THIS POINT IS TEMPORARY AND SHOULD BE REMOVED/REFACTORED EVENTUALLY -- Dante
 */
define('QUADRO_NAME_SPECIFIC', Mvc\Config::getProductNameFull());
define('PRODUCT_TYPE', 1);
define('SUBPRODUCT_TYPE', 1);
define('HW_TYPE', 5);