<?php
namespace App\Controller;

use App;
use Epygi;
use Mvc;

class IndexController extends Mvc\Controller
{
    public function cgiWrapperAction()
    {
        Epygi\Auth::rejectUnlessAuth();

        /*
         * If we are on the /mainmenu page and we have a selected conference or selected extension, we should not
         * stop here or it will be a strange user experience.  Instead, redirect over to the first page the user
         * should see based on their selected type.
         */
        if (preg_match('/mainmenu/', Mvc\Param::server('REQUEST_URI'))) {
            $ext = Epygi\Selected\Extension::getInstance();

            // selected extension
            if ($ext->isExtension() || $ext->isTemplate() || $ext->isRecording( ) || $ext->isVoiceMailBox() ) {
                // find first route this extension has permission for
                $routes = Mvc\Router::getInstance()->getLevel1Routes(true);
                $first_route = array_shift($routes);
                $url = isset($first_route['src']) ? $first_route['src'] : '/home';

                // redirect over to route url
                header('Location: ' . $url);
                exit;
            }
            // selected conference
            elseif ($ext->isConference()) {
                // find first route this extension has permission for
                $routes = Mvc\Router::getInstance()->getLevel1Routes(true);
                $first_route = array_shift($routes);
                $url = isset($first_route['src']) ? $first_route['src'] : '/home';

                // redirect over to route url
                header('Location: ' . $url);
                exit;
            }
        }

        // run cgi wrapper code
        $wrapper = new Epygi\Cgi\Wrapper();
        $wrapper->process();

        // view
        return array(
            'cgicontent' => $wrapper->content,
            'javascript' => $wrapper->js,
            'title' => $wrapper->title,
            'meta' => $wrapper->meta,
	    'backButton' => $wrapper->backButton
        );
    }

    public function helpAction()
    {
        Epygi\Auth::rejectUnlessAuth();
        $this->setTemplate('help');

        // content
        $subview = new Mvc\View(ltrim(Mvc\Param::server('SCRIPT_URL'), '/'));
        $content = $subview->render();

        // extract title
        preg_match('#<title>(.*)</title>#s', $content, $regs);
        $title = isset($regs[1]) ? $regs[1] : '';

        // remove title
        $content = preg_replace('#<title>.*</title>#s', '', $content);

        // content markup
        $content = preg_replace(
            '#<note>(.*?)</note>#s',
            '<div class="alert alert-info"><strong class="label label-info">Note:</strong> \\1</div>',
            $content
        );
        $content = preg_replace(
            '#<attention>(.*?)</attention>#s',
            '<div class="alert alert-warning"><strong class="label label-warning">Attention:</strong> \\1</div>',
            $content
        );
        // change the view script and render
        return array(
            'content' => $content,
            'title' => $title
        );
    }

    /**
     * Redirect over to the first page this user has access to.
     */
    public function homeAction()
    {
        // user must be logged in
        Epygi\Auth::rejectUnlessAuth();

        /*
         * If we are logged in as some type of admin (admin or localadmin) and we have a selected extension, we
         * want to deselect that extension and return to the list of those types.  This is how the admin will
         * "return" to the list of Extensions or list of Conferences after selecting on to manage.
         */
        if (Epygi\Auth::isAdmin() || Epygi\Auth::isLocalAdmin()) {

            // the currently selected extension/conference
            $ext = Epygi\Selected\Extension::getInstance();

            // we are an admin that has become an Extension
            if ($ext->isExtension() || $ext->isTemplate() || $ext->isRecording()) {
                // deselect the extension
                $ext->setId(false);

                // redirect to the extension list page
                header('Location: /usermanagement');
                exit;
            } // we are an admin that has become a Conference
            elseif ($ext->isConference()) {
                // deselect the conference
                $ext->setId(false);

                // redirect to the conference list page
                header('Location: /userconferences');
                exit;
            } else if ($ext->isVoiceMailBox()) {
                // deselect the voicemailbox
                $ext->setId(false);

                // redirect to the extension list page
                header('Location: /vmmanagement');
                exit;
            }

        } elseif (Epygi\Auth::isSuperAdmin()) {
            header('Location: /cloudfeatures');
            exit;
        }

        // load all ROOT routes (level 1)
        $router = Mvc\Router::getInstance();
        $routes = $router->getChildren('ROOT');

        // extract the very first route from the list of root routes and read the URL for that route
        $route = $routes ? array_shift($routes) : false;
        $url = isset($route['src']) ? $route['src'] : '/';

        // redirect to the selected URL
        header('Location: ' . $url);
        exit;
    }

    public function adminsettingsAction()
    {
        // user must be logged in
        Epygi\Auth::rejectUnlessAuth();

        /*
         * If we are logged in as some type of admin (admin or localadmin) and we have a selected extension, we
         * want to deselect that extension and return to the list of those types.  This is how the admin will
         * "return" to the list of Extensions or list of Conferences after selecting on to manage.
         */
        if (Epygi\Auth::isAdmin() || Epygi\Auth::isLocalAdmin()) {

            // the currently selected extension/conference
            $ext = Epygi\Selected\Extension::getInstance();

            // we are an admin that has become an Extension
            if ($ext->isExtension() || $ext->isTemplate()) {
                // redirect to the extension list page
                header('Location: /usermanagementedit?param=op_edit&HCI='. $ext->getId());
                exit;
            } // we are an admin that has become a Conference
            elseif ($ext->isConference()) {
                // deselect the conference
                $ext_id  = $ext->getId();
                $ext->setId(false);

                // redirect to the conference list page
                header('Location: /userconferences');
                exit;
            } else if ($ext->isVoiceMailBox()) {
                // deselect the voicemailbox

                // redirect to the extension list page
                header('Location: /vmmanagementedit?param=op_edit&HCI='.$ext->getId());
                exit;
            }
        }

        header('Location: /home');
        exit;
    }

    public function loginAction()
    {
        $this->setTemplate('login');

        // form
        $this->view->form = $form = new App\Index\LoginForm();
        $form->process();
    }
    
    public function login2faAction()
    {
	$this->setTemplate('login2fa');
	$this->view->form = $form = new App\Index\Login2faForm();
        $form->process();
    }
	
    public function logoutAction()
    {
        Epygi\Auth::logOut();
        header('Location: /login');
        exit;
    }

    public function  searchHelpAction()
    {
        Epygi\Auth::rejectUnlessAuth();
        if(isset($_GET['q'])) {
            $result=Epygi\Help::searchHelp($_GET["q"]);
            echo $result;
        }
        exit;
    }
    public function  callcgiAction()
    {
		Epygi\Auth::rejectUnlessAuth();
		$url = 'http://127.0.0.1:8080/' . $_GET['url'];
		// open curl connection remote server
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_VERBOSE, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_AUTOREFERER, true);

        // we pass our authentication token as an epycookie (created by our LoginForm)
        curl_setopt($ch, CURLOPT_COOKIE, 'epycookie=' . Epygi\Auth::getCgiSessionId());

        // execute the request
        $response = curl_exec($ch);

        // separate the header from the body
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $header = substr($response, 0, $header_size);
        $body = substr($response, $header_size);

        // Close connection
        curl_close($ch);
		echo $body;
		exit;
    }
}