<?php
namespace App\Index;

use Epygi;
use Epygi\Enum\Role as ERole;
use Mvc;

class LoginForm extends Epygi\Form\AbstractForm
{
    const BRUTE_FORCE_ATTEMPT_COUNT_LIMIT = 3; // seconds (5 minutes)
    const BRUTE_FORCE_ATTEMPT_TIMEOUT_SECONDS = 300;
    private $attempt_count = 0;

    private function bruteCleanupAndBlockCheck()
    {
        // brute log file
        $config = Epygi\Storage\ConfigFactory::bruteForceLogin();

        // loop through all sections and remove expired blocks
        foreach ($config as $section) {
            // attempt count and last_attempt
            $last_attempt = $section->get('last_attempt');

            // invalid block (no attempt time set), or attempt timeout has expired
            if (!$last_attempt || $last_attempt < (time() - self::BRUTE_FORCE_ATTEMPT_TIMEOUT_SECONDS)) {
                // remove expired ip block
                unset($config[$section->getName()]);
            }
        }

        // save cleanup
        $config->save();

        // ip section
        $remote_ip = Mvc\Param::server('REMOTE_ADDR');
        $section = $config[$remote_ip];

        // how many time have they tried to log in?
        $this->attempt_count = $section->get('attempt');

        // have we exceeded our allowed attempts?
        return ($this->attempt_count >= self::BRUTE_FORCE_ATTEMPT_COUNT_LIMIT);
    }

    /**
     * Log a brute force login attack attempt.  Each time an invalid username/password is used, we mark attempts by
     * the IP address in a special file and start blocking login after a given number of attempts in a predefined
     * timeout period.
     */
    private function bruteLogAttempt()
    {
        // brute log file
        $config = Epygi\Storage\ConfigFactory::bruteForceLogin();

        // ip section
        $remote_ip = Mvc\Param::server('REMOTE_ADDR');
        $section = $config[$remote_ip];

        // count attempts and mark attempt timestamp
        $section->set('attempt', $section->get('attempt', 0) + 1);
        $section->set('last_attempt', time());
        $config->save();
    }

    private function bruteReset()
    {
        // brute log file
        $config = Epygi\Storage\ConfigFactory::bruteForceLogin();

        // remove section by ip
        $remote_ip = Mvc\Param::server('REMOTE_ADDR');
        unset($config[$remote_ip]);

        // TODO: loop through remaining entries and remove expired records ...
        $config->save();
    }

    public function execute()
    {
        // look up password for this user
        $config = Epygi\Storage\ConfigFactory::acldb();
        $usercfg = $config[$this->username];

        // factory reset "password" used when "gui_pswd" is not present (if the device is reset)

	if ($this->username == 'superadmin') {
        $this->password = md5($this->username . ':' . "cgi Epygi realm" . ':' . $this->password);
    }

        try {
            $pwd_check = Epygi\Shell\Command\CheckSAM::samCheck($this->username, $this->password);
        }
        catch(\Exception $e) {
            $pwd_check = array(0,0,0);
        }

        // this user account is enabled?
        $enabled = $usercfg->getBool('enabled', false);

        // assume we did not match a valid role
        $role = false;

        /**
         * perform cleanup on the brute force log file and check if this user is currently blocked.  If they are
         * blocked, just give a generic error message ... don't tell them how much longer they will be blocked!  This
         * is supposed to be a punishment, they will learn from their mistakes the hard way.
         */
        if ($this->bruteCleanupAndBlockCheck()) {
            return $this->syserr(_('Too many log in attempts from this IP.  IP has been temporarily blocked (5 min).'));
        }

        // ADMIN - this is the admin user
        if ($this->username == 'admin') {
            if ($enabled && ( $pwd_check[0] == 1 ||
                ($pwd_check[0] == -1 && $pwd_check[1] == 1))) {
                $role = ERole::ADMIN;
            }
        }

        // LOCALADMIN - this is the local admin user
        elseif ($this->username == 'localadmin') {
            if ($enabled && ( $pwd_check[0] == 1 ||
                ($pwd_check[0] == -1 && $pwd_check[1] == 1))) {
                $role = ERole::LOCALADMIN;
            }
        }
        // SUPERADMIN - this is the super admin user
        elseif ($this->username == 'superadmin') {
             if ($enabled && ( $pwd_check[0] == 1 ||
                ($pwd_check[0] == -1 && $pwd_check[1] == 1))) {
                $role = ERole::SUPERADMIN;
            }
        }
        // EXTENSION - we are not an admin, trying logging in as extension (user extension, recording, conference, etc)
        else {
            $role = $this->matchExtension($this->username, $this->password);
        }

        // INVALID - all logins above failed, not logged in still
        if (!$role) {

            // track brute force attempts
            $this->bruteLogAttempt();
            $logEvent=true;
            if ($this->username == 'superadmin' && Mvc\Feature::hasCloudOwnService()) {
          	  $logEvent=false;
            }

            if($logEvent) {
            // log event
          	  $message = _('Authentication failure for user %s (%d times, peer IP=%s)');
          	  $message = sprintf($message, $this->username, $this->attempt_count + 1, Mvc\Param::server('REMOTE_ADDR'));
          	  Epygi\Shell\Command\RaiseEvent::raiseEvent('system', 'login failure', $message);
            }

            // reset session and return error
            Epygi\Auth::logOut();
            return $this->syserr(_('Invalid username or password. Please try to log in again.'));
        }
		
        // Two Factor Authentication
	if(Epygi\Auth::is2faLoginRequired($this->username)) {
		Epygi\Auth::before2FalogIn($this->username,$role);
	    header('Location: /login2fa');
	    exit;
	}
	//
		
        // SUCCESS!

        // reset our brute force checks for this IP
        $this->bruteReset();

        // log this user in with the given role
        Epygi\Auth::logIn($this->username, $role);

	if($role != ERole::SUPERADMIN) {
        // log event
        $message = _('Authentication success for user %s (peer IP=%s)');
        $message = sprintf($message, Epygi\Auth::getUsername(), Mvc\Param::server('REMOTE_ADDR'));
        Epygi\Shell\Command\RaiseEvent::raiseEvent('system', 'login', $message);
    }

        // if we wanted a specific page, redirect to the page we originally wanted
        Epygi\Auth::wantUriRedirect();

        // redirect to the /home url which will again redirect to the proper first page
        header('Location: /home');
        exit;
    }

    protected function matchExtension($extension_id, $in_password)
    {
        // reference an extension with the given name
        $extension = new Epygi\Storage\Extension($extension_id);
        $type = $extension->getExtensionType();

        // based on extension type, check password
        switch ($type) {
            case 'extension':
            case 'recordingbox':
            case 'conference':
                $config = $extension->getConfig('personal');

                if ($type != 'conference') {
                    // make sure gui login is allowed
                    if (!$config->getBool('is_login_allowed')) {
                        return false;
                    }
                }

                $password = '';
                $encryptedpassword = $config->get('password');

                try {
                    if(Epygi\Shell\Command\CheckSAM::decryptPass($encryptedpassword, $password) != 0) {
                        return false;
                    }
                }
                catch(\Exception $e) {
                    return false;
                }

                // SPR PG-18426 - password is not required to log in as an extension
                // password matches!
                if ($password == $in_password) {
                    // [conference] = conference, [extension | recordingbox] => extension

                    if ($type == 'conference')
                        return ERole::CONFERENCE;
                    elseif ($type == 'recordingbox')
                        return ERole::RECORDING;
                    else
                        return ERole::EXTENSION;
                }
                break;
            case 'voicemailbox':
                $config = $extension->getConfig('personal');
                $login_allowed = (bool) isset($config['is_login_allowed']) ? $config['is_login_allowed'] : false;
                $password = isset($config['password']) ? $config['password'] : '';
                if (!$login_allowed) {
                    return false;
                }

                if ($password == $in_password) {
                    return ERole::VOICEMAILBOX;
                }
                break;
        }

        // unknown extension type or invalid password
        return false;
    }

    /**
     * remove all session data on page load
     */
    protected function onFirstLoad()
    {
        $this->clear();
    }

    /**
     * 1) track login attempts [per IP address] > MAX = banned for time period
     * 2) session expired, show message
     * 3) httpstatustester polling 127.0.0.1 or something like that ...
     * 4) choose session language
     * 5) session = USERNAME, REMOTE_ADDR, LANG, THEME
     */
    protected function prepare()
    {
        // reset
        $this->clear('username', 'password');

        // required
        $this->req('username', _('The username must not be empty.'));

        // SPR PG-18426 - password is not required to log in as an extension
        // $this->req('password', 'The password must not be empty.');
    }
}