<?php
namespace App\Maintenance;

use Epygi;

class TracerouteForm extends Epygi\Form\AbstractForm
{
    public function execute()
    {
        return true;
    }

    protected function onFirstLoad()
    {
        // reset
        $this->clear();
    }

    protected function prepare()
    {
        // required
        //$this->req('target');

        $this->hasAccessRights= Epygi\Storage\AclDb::hasAccessRights('traceroute', Epygi\Auth::getRole());
        
        // generate URL to our traceroute command url
        $this->command_url = false;
        if ($this->target) {
            $url = new Epygi\Url('/maintenance/traceroute-command');
            $url->attr('target', $this->target);
	    $url->attr('use_icmp', $this->use_icmp);
            $this->command_url = (string) $url;
        }
    }
}