<?php

class ApiException extends Exception {
  protected $logData;
  protected $logSection;

  public function __construct($message, $code = ApiConstants::http_Internal_Server_Error, $logData = array(), $logSection = LogMgmt::SECTION_DEBUG) {
    parent::__construct($message, $code, null);
    $this->logData = $logData;
    $this->logSection = $logSection;
  }

  public function getSection() {
    return $this->logSection;
  }

  public function getLogData() {
    if(count($this->logData) > 0) {
      return $this->logData;
    }

    $rawResponse = array(
      ApiConstants::KEY_SUCCESS => false,
      ApiConstants::KEY_ERROR => array(
          ApiConstants::KEY_CODE => $this->getCode(),
          ApiConstants::KEY_MESSAGE => $this->getMessage()
      )
    );
    return array(ApiConstants::MESSAGE => $this->getMessage(), ApiConstants::KEY_RAW_RESPONSE => $rawResponse);
  }
}
