<?php
use Epygi\Storage;
use Epygi\Shell\Command;
const DEFAULT_TOLERANCE = 300;
$tolerance = DEFAULT_TOLERANCE;

function VerifyHeader($payload, $signature, $key)
{
    $cmd = new Command('/bin/sms');
    $cmd->opt('--vs');
    $cmd->opt('-p');
    $cmd->opt($payload);
    $cmd->opt('-s');
    $cmd->opt($signature);
    $cmd->opt('-k');
    $cmd->opt($key);
    return $cmd->execute();
}

function SendSipSMS($from, $to, $msg, $msgSid, $msgStatus)
{
    $cmd = new Command('/bin/notifier'); 
    $cmd->opt('-sendsipimfromdim'); 
    $cmd->opt($from); 
    $cmd->opt($to);
    $cmd->opt("'" . $msg . "'");
    $cmd->opt("\"$msgSid\"");
    $cmd->opt("\"$msgStatus\"");
    return $cmd->execute();
}

if (!isset($_SERVER['HTTP_TELNYX_SIGNATURE_ED25519']) || !isset($_SERVER['HTTP_TELNYX_TIMESTAMP'])) {
    http_response_code(401);
    die("Unauthorized");
}

$conf = new Epygi\Storage\Sms();
$my_public_key = $conf->GetTelnyxPublicKey();

if( empty($my_public_key) ) {
    http_response_code(501);
    die("Not Implemented");
}

$payload = @file_get_contents('php://input');

$signature_header = $_SERVER['HTTP_TELNYX_SIGNATURE_ED25519'];
$timestamp_header = $_SERVER['HTTP_TELNYX_TIMESTAMP'];
$timestamp_header = (int)$timestamp_header;

// Check if timestamp is within tolerance
if (($tolerance > 0) && (\abs(\time() - $timestamp_header) > $tolerance)) {
    http_response_code(401);
    die("Timestamp outside the tolerance zone");
}

// Construct a message to test against the signature header using the timestamp and payload
$signed_payload = $timestamp_header . '|' . $payload;
$signed_payload = "'" . $signed_payload . "'";

if( VerifyHeader($signed_payload, $signature_header, $my_public_key) ) {
    http_response_code(401);
    die("Unauthorized");
}

$json = json_decode(file_get_contents("php://input"), true);
if($json) {
		$record_type = $json['data']['record_type'];
		if($record_type == "event") {
			$id = $json['data']['id'];
			$event_type = $json['data']['event_type'];
            $payload = $json['data']['payload'];
            $payload_type = $payload['record_type'];
            $payload_direction = $payload['direction'];

			if($payload_direction == "inbound" && $event_type == "message.received") {
                if($payload_type == "message") {
                    $from = $payload['from']['phone_number'];
                    $body = $payload['text'];
                    $sid = $payload['id'];
                    foreach($payload['to'] as $dest) {
                        $status = $dest['status'];
                        $to = $dest['phone_number'];
                        syslog(LOG_INFO, "Inbound SMS From: $from To: $to sid: $sid Status: $status") ;
                        $res=SendSipSMS($from,$to,$body,$sid,$status);
                        syslog(LOG_INFO, "Sending IM to sip From: $from To: $to res=$res") ;
                        if($res != 0){
                            http_response_code(500);
                            die("Not Internal Server Error");
                        }
                    }               
                }
			}
            else if ($event_type == "message.finalized" && $payload_direction == "outbound") {
                    if($payload_type == "message") {
                        $sid = $payload['id'];
                        if(!empty($sid)){
                            foreach($payload['to'] as $dest) {
                                $status = $dest['status'];
                                syslog(LOG_INFO, "SID: $sid, Status: $status");
                                try {
                                    $pdo = new PDO('sqlite:/mnt/bbram/calldata/smsdetail.db');
                                    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                                    $qs='UPDATE sms SET msg_status = "' . $status . '" WHERE msg_sid == "' . $sid . '"';
                                    echo $qs;
                                    $pdo->query($qs);
                                }
                                catch (Exception $e) {
                                    syslog(LOG_INFO, "Caught exception: $e->getMessage()");
                                }
                                break;
                            }
                        }
                    }
            }
	 }
}

closelog();

http_response_code(200);
